IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_AJUSTE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_AJUSTE]
GO
IF NOT EXISTS (SELECT 1 FROM SYSCOLUMNS WHERE id = object_id('EST_PROD_TRANSF') and name = 'AJUSTADO')
	BEGIN
		ALTER TABLE EST_PROD_TRANSF ADD AJUSTADO TINYINT NULL;
	END
GO 

IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE NAME ='EST_PROD_TRANSF_AJUSTE_RESSUP')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AJUSTE_RESSUP
	END		
	CREATE TABLE dbo.EST_PROD_TRANSF_AJUSTE_RESSUP ( CD_EMP	INT, 
														CD_FILIAL	INT,
														CD_PROD		INT, 
														QT_EST_DEPO_RES	MONEY,
														QT_SOL			MONEY,
														QTD_DIFF		MONEY,
														FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT);

GO

CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_AJUSTE] @CD_EMP				INT, 
																			@CD_CTR_DEPO		INT, 
																			@DT_REF				DATETIME,
																			@CD_FILIAL			INT
WITH ENCRYPTION AS
 SET NOCOUNT ON;
	IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE NAME ='EST_PROD_TRANSF_AJUSTE_RESSUP')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AJUSTE_RESSUP
	END		
	CREATE TABLE dbo.EST_PROD_TRANSF_AJUSTE_RESSUP ( CD_EMP	INT, 
														CD_FILIAL	INT,
														CD_PROD		INT, 
														QT_EST_DEPO_RES	MONEY,
														QT_SOL			MONEY,
														QTD_DIFF		MONEY,
														FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT);
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
					WHERE NAME ='EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL
	END		
	DECLARE @FILIAL_DEPO INT;
	SET @FILIAL_DEPO = (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO WHERE CD_EMP=@CD_EMP AND CD_CTR_DEPO= @CD_CTR_DEPO)
	CREATE TABLE dbo.EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL ( CD_EMP		INT, 
															CD_FILIAL	INT,
															CD_CTR		INT,
															CD_PROD		INT,
															MEDIAF		MONEY,
															QT_UNI_RESSUPRIMENTO	MONEY,
															FLAG_RESSUPRIMENTO_CAIXA_FECHADA	 INT,
															QT_SOL	MONEY,
															QT_EST_RES	MONEY,
															QT_EST_DEPO_RES	 MONEY,
															QTD_DIFF MONEY)
	 --Carga dos produtos que precisam ser ajustados a quantidade
	 INSERT INTO EST_PROD_TRANSF_AJUSTE_RESSUP
	 SELECT 
		D.CD_EMP, 
		D.CD_FILIAL,
		D.CD_PROD, 
		D.QT_EST_DEPO_RES,
		R.QT_SOL,
		D.QT_EST_DEPO_RES -	R.QT_SOL QTD_DIFF ,
		P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
	FROM 
		(SELECT	 
			I.CD_EMP, 
			RES.CD_FILIAL, 
			I.CD_PROD, 
			min(i.QT_EST_DEPO_RES) QT_EST_DEPO_RES
		FROM         
			EST_PROD_TRANSF RES 
			INNER JOIN EST_PROD_TRANSF_IT I ON 
			RES.CD_EMP		= I.CD_EMP AND 
			RES.CD_FILIAL	= I.CD_FILIAL AND 
			RES.CD_CTR		= I.CD_CTR
		WHERE
			RES.CD_EMP=1
			AND RES.STS_TRANSF=0
			AND RES.DT_TRANSF= @DT_REF
			AND RES.CD_FILIAL=@FILIAL_DEPO
			AND I.QT_SOL > 0
			AND not ISNULL(RES.AJUSTADO,0)=1
			AND (res.CD_FIL_DEST=@CD_FILIAL OR @CD_FILIAL=0 )
			and res.TP_TRANSF=0
		GROUP BY 
			I.CD_EMP, 
			RES.CD_FILIAL, 
			I.CD_PROD	) D
		INNER JOIN (SELECT	  
							I.CD_EMP, 
							RES.CD_FILIAL,
							I.CD_PROD, 
							SUM(I.QT_SOL ) QT_SOL
						FROM         
							EST_PROD_TRANSF RES 
							INNER JOIN EST_PROD_TRANSF_IT I ON 
							RES.CD_EMP		= I.CD_EMP AND 
							RES.CD_FILIAL	= I.CD_FILIAL AND 
							RES.CD_CTR		= I.CD_CTR
						WHERE
							RES.CD_EMP=1
							AND RES.DT_TRANSF=@DT_REF
							AND RES.CD_FILIAL=@FILIAL_DEPO
							AND RES.STS_TRANSF=0
							AND I.QT_SOL > 0
							AND not ISNULL(RES.AJUSTADO,0)=1
							AND (res.CD_FIL_DEST=@CD_FILIAL OR @CD_FILIAL=0 )
							and res.TP_TRANSF=0
						GROUP BY 
							I.CD_EMP, 
							RES.CD_FILIAL,
							I.CD_PROD) R ON  
		D.CD_EMP	= R.CD_EMP AND
		D.CD_FILIAL	= R.CD_FILIAL AND
		D.CD_PROD	= R.CD_PROD
		INNER JOIN EST_PROD P ON 
				R.CD_EMP		= P.CD_EMP AND 
				R.CD_PROD		= P.CD_PROD 
		AND D.QT_EST_DEPO_RES < R.QT_SOL 
	if 1 = 1
	begin
		--Enquanto houver produtoCarga dos produtos que precisam ser ajustados a quantidade
		 while exists(SELECT TOP 1 res.cd_emp
								FROM  
									EST_PROD_TRANSF RES 
									INNER JOIN EST_PROD_TRANSF_IT I ON 
									RES.CD_EMP		= I.CD_EMP AND 
									RES.CD_FILIAL	= I.CD_FILIAL AND 
									RES.CD_CTR		= I.CD_CTR 
									INNER JOIN EST_PROD_TRANSF_AJUSTE_RESSUP A ON 
									RES.CD_EMP		= A.CD_EMP AND 
									RES.CD_FILIAL	= A.CD_FILIAL AND
									I.CD_PROD		= A.CD_PROD 
								WHERE
									RES.CD_EMP=1
									AND RES.DT_TRANSF= @DT_REF
									AND RES.CD_FILIAL=@FILIAL_DEPO
									AND RES.STS_TRANSF=0
									AND not ISNULL(RES.AJUSTADO,0)=1
									AND I.QT_SOL > 0
									AND RES.TP_TRANSF=0
									and A.QTD_DIFF<0 )
		begin
			truncate table EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL;
			INSERT INTO EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL
			SELECT TOP 1
				RES.CD_EMP,
				RES.CD_FILIAL,
				RES.CD_CTR,
				A.CD_PROD,
				0 MEDIAF,
				I.QT_UNI_RESSUPRIMENTO,
				A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
				I.QT_SOL, 
				I.QT_EST_RES,
				A.QT_EST_DEPO_RES,
				A.QTD_DIFF
			FROM  
				EST_PROD_TRANSF RES 
				INNER JOIN EST_PROD_TRANSF_IT I ON 
				RES.CD_EMP		= I.CD_EMP AND 
				RES.CD_FILIAL	= I.CD_FILIAL AND 
				RES.CD_CTR		= I.CD_CTR  
				INNER JOIN EST_PROD_TRANSF_AJUSTE_RESSUP A ON 
				RES.CD_EMP		= A.CD_EMP AND 
				RES.CD_FILIAL	= A.CD_FILIAL AND
				I.CD_PROD		= A.CD_PROD				 
			WHERE
				RES.CD_EMP=1
				AND RES.DT_TRANSF= @DT_REF
				AND RES.CD_FILIAL=@FILIAL_DEPO
				AND I.QT_SOL > 0
				AND RES.STS_TRANSF=0
				AND not ISNULL(RES.AJUSTADO,0)=1
				and res.TP_TRANSF=0
				and A.QTD_DIFF<0
			ORDER BY 	
				res.CD_EMP, 
				res.CD_FILIAL,
				A.CD_PROD,
				I.QT_SOL  DESC, 
				I.QT_EST_RES DESC ; 
			insert into EST_PROD_TRANSF_AJUSTE_RESSUP_HIST(CD_EMP,CD_FILIAL,CD_CTR ,CD_PROD ,QT_SOL ,QT_EST_RES,QT_EST_DEPO_RES,QTD_DIFF,DT_CAD)
			select 
				  CD_EMP         
				 ,CD_FILIAL      
				 ,CD_CTR         
				 ,CD_PROD        
				 ,QT_SOL         
				 ,QT_EST_RES     
				 ,QT_EST_DEPO_RES
				 ,QTD_DIFF       
				 ,getdate() DT_CAD         
			from 
				EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL
			UPDATE I
			SET
				I.QT_SOL	 = I.QT_SOL  - (case when isnull(f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,0)=1 then
										isnull(i.QT_UNI_RESSUPRIMENTO,1) else 1 end)
			FROM	
				EST_PROD_TRANSF_IT  i
				INNER JOIN EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL F ON 
				I.CD_EMP	= f.CD_EMP AND
				I.CD_FILIAL	= f.CD_FILIAL AND
				I.CD_CTR	= f.CD_CTR  AND
				I.CD_PROD	= f.CD_PROD
			WHERE
				I.CD_EMP=@CD_EMP  
				AND I.CD_FILIAL=@FILIAL_DEPO
			update a
			set
				a.QT_SOL = A.QT_SOL - (case when f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
										QT_UNI_RESSUPRIMENTO else 1 end), 
				a.QTD_DIFF	 = A.QTD_DIFF  + (case when f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
												QT_UNI_RESSUPRIMENTO else 1 end)
			FROM 
				EST_PROD_TRANSF_AJUSTE_RESSUP  a
				inner join EST_PROD_TRANSF_AJUSTE_RESSUP_FINAL f on 
				a.cd_emp	= f.cd_emp and
				a.cd_filial = f.cd_filial and
				a.cd_prod	= f.cd_prod 
		end	  
	end
	PRINT 'Deletando ressuprimento sem itens(' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
	DELETE FROM I
	FROM         
		EST_PROD_TRANSF res 
		INNER JOIN EST_PROD_TRANSF_IT I ON 
		res.CD_EMP		= I.CD_EMP AND 
        res.CD_FILIAL	= I.CD_FILIAL AND 
		res.CD_CTR		= I.CD_CTR
		--Filiais do mesmo deposito
		INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL lj ON
		res.CD_EMP		= lj.CD_EMP AND
		res.CD_FIL_DEST	= lj.CD_FILIAL
		AND lj.CD_CTR_DEPO =@CD_CTR_DEPO
	WHERE   
		RES.CD_EMP		= @CD_EMP
		AND I.QT_SOL <=0
		AND RES.TP_TRANSF=0
		AND RES.CD_FILIAL=@FILIAL_DEPO
		AND RES.DT_CAD =@DT_REF;
	--Deleta itens sem estoque no deposito
	DELETE FROM I
	FROM         
		EST_PROD_TRANSF res 
		INNER JOIN EST_PROD_TRANSF_IT I ON 
		res.CD_EMP		= I.CD_EMP AND 
        res.CD_FILIAL	= I.CD_FILIAL AND 
		res.CD_CTR		= I.CD_CTR
	WHERE   
		res.CD_EMP	= @CD_EMP
		AND ISNULL(I.QT_EST_DEPO_RES,0) < 1
		and res.TP_TRANSF=0
		AND RES.CD_FILIAL=@FILIAL_DEPO
		AND RES.DT_CAD =@DT_REF;
	DELETE 
		res
	FROM         
		EST_PROD_TRANSF res 
		LEFT OUTER JOIN EST_PROD_TRANSF_IT I ON 
		res.CD_EMP		= I.CD_EMP AND 
        res.CD_FILIAL	= I.CD_FILIAL AND 
		res.CD_CTR		= I.CD_CTR
		LEFT   JOIN EST_PROD_TRANSF_CONF_FASES f ON 
		res.CD_EMP		= f.CD_EMP AND 
        res.CD_FILIAL	= f.CD_FILIAL AND 
		res.CD_CTR		= f.CD_CTR 
		LEFT   JOIN EST_PROD_TRANSF_EST_WMS_SAI w ON 
		res.CD_EMP		= w.CD_EMP AND 
        res.CD_FILIAL	= w.CD_FILIAL AND 
		res.CD_CTR		= w.CD_CTR 
		--Filiais do mesmo deposito
		INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL lj ON
		res.CD_EMP		= lj.CD_EMP AND
		res.CD_FIL_DEST	= lj.CD_FILIAL
		AND lj.CD_CTR_DEPO =@CD_CTR_DEPO 
	WHERE   
		res.CD_EMP = @CD_EMP
		AND RES.CD_FILIAL=@FILIAL_DEPO
		AND I.CD_PROD IS NULL
		AND f.CD_EMP IS NULL
		AND w.CD_EMP IS NULL
		AND RES.DT_CAD =@DT_REF;
		UPDATE EST_PROD_TRANSF  SET AJUSTADO=1
		WHERE   
			CD_EMP		= @CD_EMP
		AND CD_FILIAL	= @FILIAL_DEPO
		AND TP_TRANSF	= 0
		AND STS_TRANSF	= 0
		AND DT_CAD		= @DT_REF;